unit fROR_ICRPatientEdit;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 35 $  $Modtime: 3/06/07 2:16p $
*       Site:           Hines OIFO
*       Developers:     Andrey Andriyevskiy
*                                      
*       Description:    ICR Patient Record Editor
*
*	Notes:
*
================================================================================
*	$Archive: /CCR v1.5/Current/fROR_ICRPatientEdit.pas $
*
* $History: fROR_ICRPatientEdit.pas $
 * 
 * *****************  Version 35  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 34  *****************
 * User: Vhaishgavris Date: 10/27/05   Time: 3:54p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 33  *****************
 * User: Vhaishgavris Date: 9/07/05    Time: 3:45p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 32  *****************
 * User: Vhaishgavris Date: 8/20/05    Time: 2:46p
 * Updated in $/CCR v1.0/Current
 *
*
================================================================================
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fROR_PatientEdit, ImgList, ActnList, Buttons, StdCtrls, ComCtrls,
  ExtCtrls, uROR_Common, uROR_ICRPatientData, uROR_CustomControls, Grids,
  uROR_Errors, uROR_Strings, uROR_ListView, uROR_CustomListView,
  uROR_GridView, fROR_VistARegistries, BaseGrid, AdvGrid, AdvCGrid,
  uROR_AdvColGrid, VA508AccessibilityManager;

type
  TFormICRPatientEdit = class(TFormPatientEdit)
    cbgBloodComponent: TCCRCBGroup;
    cbgClottingFactor: TCCRCBGroup;
    cbgClottingfactorType: TCCRCBGroup;
    cbgHSRwBisexualMale: TCCRCBGroup;
    cbgHSRwHemophilia: TCCRCBGroup;
    cbgHSRwHIV: TCCRCBGroup;
    cbgHSRwIVDrugUser: TCCRCBGroup;
    cbgHSRwTransfusion: TCCRCBGroup;
    cbgHSRwTransplant: TCCRCBGroup;
    cbgNonprescrDrug: TCCRCBGroup;
    cbgSexWithFemale: TCCRCBGroup;
    cbgSexWithMale: TCCRCBGroup;
    cbgTransplant: TCCRCBGroup;
    edtIVFirstYear: TEdit;
    edtIVLastYear: TEdit;
    edtIVOtherFactorType: TEdit;
    GroupBox24: TGroupBox;
    tsRiskFactors: TTabSheet;
    pnlStatus: TPanel;
    dtpAIDSOIDate: TDateTimePicker;
    stxtSexWithMale: TStaticText;
    stxtSexWithFemale: TStaticText;
    stxtNonprescrDrug: TStaticText;
    stxtClottingFactor: TStaticText;
    stxtHeterosexual: TStaticText;
    stxtHSRwBisexualMale: TStaticText;
    stxtHSRwIVDrugUser: TStaticText;
    stxtHSRwHemophilia: TStaticText;
    stxtHSRwTransfusion: TStaticText;
    stxtHSRwTransplant: TStaticText;
    stxtHSRwHIV: TStaticText;
    stxtBloodComponent: TStaticText;
    stxtTransplant: TStaticText;
    cbgHCWorker: TCCRCBGroup;
    edtHCOccupation: TEdit;
    stxtHCWorker: TStaticText;
    stxtHCOccupation: TStaticText;
    stxtIVLastYear: TStaticText;
    stxtIVFirstYear: TStaticText;
    cbgAIDSFirstDiag: TCCRCBGroup;
    stxtAIDSFirstDiag: TStaticText;
    cbgAIDSOI: TCCRCBGroup;
    stxtAIDSOI: TStaticText;
    stxtAIDSOIDate: TStaticText;

    procedure cbgBloodComponentChange(Sender: TObject);
    procedure cbgHCWorkerChange(Sender: TObject);
    procedure cbgClottingFactorChange(Sender: TObject);
    procedure cbgClottingfactorTypeChange(Sender: TObject);
    procedure edV_MonthYearKeyPress(Sender: TObject; var Key: Char);
    procedure cbgAIDSOIChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  protected
    function  getPatientData: TICRPatientData;
    function  PopulateControls: TReturnCode; override;
    function  UpdateDataSet: TReturnCode; override;

  public
    procedure AfterConstruction; override;
    property PatientData: TICRPatientData read getPatientData;
  end;

implementation
{$R *.DFM}

uses
  uROR_Broker, uROR_CommonUtils, uROR_Utilities, fROR_Options, uROR_Classes,
  uROR_PatientDataLists;

procedure TFormICRPatientEdit.AfterConstruction;
var
  i: integer;
begin
  inherited;
  if CCRScreenReaderActive then
  begin
    for i := 0 to ComponentCount - 1 do
      if (Components[i] is TStaticText) then
      begin
        with TStaticText(Components[i]) do
          TabStop := true;
      end;
  end;
end;

procedure TFormICRPatientEdit.cbgAIDSOIChange(Sender: TObject);
begin
  inherited;
  if cbgAIDSOI.Code = '1' then
  begin
    dtpAIDSOIDate.Color   := CtrlColor(true);
    stxtAIDSOIDate.Enabled := true;
    dtpAIDSOIDate.Enabled  := true;
  end
  else begin
    dtpAIDSOIDate.Color   := CtrlColor(false);
    stxtAIDSOIDate.Enabled := false;
    dtpAIDSOIDate.Enabled  := false;
  end;
end;

procedure TFormICRPatientEdit.cbgBloodComponentChange(Sender: TObject);
begin
  inherited;
  if cbgBloodComponent.Code = '1' then
    begin
      edtIVFirstYear.Color   := CtrlColor(True);
      edtIVFirstYear.Enabled := True;
      edtIVLastYear.Color    := CtrlColor(True);
      edtIVLastYear.Enabled  := True;
      stxtIVFirstYear.Enabled := True;
      stxtIVLastYear.Enabled  := True;
    end
  else
    begin
      edtIVFirstYear.Color   := CtrlColor(False);
      edtIVFirstYear.Enabled := False;
      edtIVFirstYear.Text    := '';
      edtIVLastYear.Color    := CtrlColor(False);
      edtIVLastYear.Enabled  := False;
      edtIVLastYear.Text     := '';
      stxtIVFirstYear.Enabled := False;
      stxtIVLastYear.Enabled  := False;
    end;
end;

procedure TFormICRPatientEdit.cbgClottingFactorChange(Sender: TObject);
begin
  inherited;
  if cbgClottingFactor.Code = '1' then
    begin
      cbgClottingfactorType.Enabled := True;
    end
  else
    begin
      cbgClottingfactorType.Code    := '';
      cbgClottingfactorType.Enabled := False;
    end;
end;

procedure TFormICRPatientEdit.cbgClottingfactorTypeChange(Sender: TObject);
begin
  inherited;
  if cbgClottingfactorType.Code = '8' then
    begin
      edtIVOtherFactorType.Color   := CtrlColor(True);
      edtIVOtherFactorType.Enabled := True;
    end
  else
    begin
      edtIVOtherFactorType.Color   := CtrlColor(False);
      edtIVOtherFactorType.Enabled := False;
      edtIVOtherFactorType.Text    := '';
    end;
end;

procedure TFormICRPatientEdit.cbgHCWorkerChange(Sender: TObject);
begin
  inherited;
  if cbgHCWorker.Code = '1' then
    begin
      edtHCOccupation.Color   := CtrlColor(True);
      edtHCOccupation.Enabled := True;
      stxtHCOccupation.Enabled := True;
    end
  else
    begin
      edtHCOccupation.Color   := CtrlColor(False);
      edtHCOccupation.Enabled := False;
      edtHCOccupation.Text    := '';
      stxtHCOccupation.Enabled := False;
    end;
end;

procedure TFormICRPatientEdit.edV_MonthYearKeyPress(Sender: TObject;
  var Key: Char);
begin
  UpdateEdit(Key, Sender);
end;

procedure TFormICRPatientEdit.FormActivate(Sender: TObject);
begin
  inherited;
  //-- Section 508: Display a warning regarding disabled controls.
  if CCRScreenReaderActive then
    MessageDlg508('', RSC50801, mtWarning, [mbOK], 0);
end;

function TFormICRPatientEdit.getPatientData: TICRPatientData;
begin
  Result := TICRPatientData(inherited getPatientData);
end;

function TFormICRPatientEdit.PopulateControls: TReturnCode;

  function checkDate(aValue: String): String;
  begin
    if aValue <> '' then
      Result := FMDateTimeStr(aValue)
    else
      Result := 'Unknown';
  end;

  function checkValue(aValue: String): String;
  begin
    if aValue <> '' then
      Result := aValue
    else
      Result := 'Unknown';
  end;

begin
  Result := inherited PopulateControls;
  if IsRCError(Result) then Exit;

  with PatientData do
    begin
      //--- Clinical Status Tab

      cbgAIDSFirstDiag.Code       := AIDSFirstDiag;
      cbgAIDSOI.Code              := AIDSOI;
      try
        if (cbgAIDSOI.Code = '1') and (AIDSOIDate <> '') then
          dtpAIDSOIDate.Date := FMDateTimeToWindowsDateTime(StrToFloat(AIDSOIDate))
        else
          dtpAIDSOIDate.Date := Now;
      except
        dtpAIDSOIDate.Date := Now;
      end;

      //--- Patient History Tab

      cbgBloodComponent.Code      := BloodComponent;
      cbgClottingFactor.Code      := ClottingFactor;
      cbgClottingfactorType.Code  := ClottingFactorType;
      cbgHCWorker.Code            := HCWorker;
      cbgNonprescrDrug.Code       := NonprescrIVDrug;
      cbgSexWithFemale.Code       := SexWithFemale;
      cbgSexWithMale.Code         := SexWithMale;
      cbgHSRwBisexualMale.Code    := HSRwBisexualMale;
      cbgHSRwHemophilia.Code      := HSRwHemofilia;
      cbgHSRwHIV.Code             := HSRwHIV;
      cbgHSRwIVDrugUser.Code      := HSRwIVDrugUser;
      cbgHSRwTransfusion.Code     := HSRwTransfusion;
      cbgHSRwTransplant.Code      := HSRwTransplant;
      cbgTransplant.Code          := Transplant;
      edtHCOccupation.Text        := HCWorkerOccupation;
      edtIVFirstYear.Text         := BloodComponentFirst;
      edtIVLastYear.Text          := BloodComponentLast;
      edtIVOtherFactorType.Text   := ClottingFactorOther;
    end;
end;

function TFormICRPatientEdit.UpdateDataSet: TReturnCode;
var
  hse: String;
  iDateError: integer;

  //--- Check for valid dates (MM/YY or MM/YYYY) and no future dates
  function checkDate(aValue: String): integer;
  var aDate: TDateTime;
  begin
    result := 0;
    if pos('/', aValue) > 0 then
    begin
      try
        aDate := StrToDate(piece(aValue,'/',1) + '/1/' + piece(aValue,'/',2));
        if aDate > Now() then
          result := 1;
      except
        result := -1;
      end;
    end
    else
      result := -1;
  end;

begin
  Result := inherited UpdateDataSet;
  if IsRCError(Result) then Exit;

  with PatientData do
    begin
      hse := '';

      //--- Clinical Status Tab

      AIDSFirstDiag := cbgAIDSFirstDiag.Code;
      if cbgAIDSFirstDiag.Code = '' then
        hse := hse + RSC00101 + #13;

      AIDSOI := cbgAIDSOI.Code;
      if AIDSOI = '1' then
      begin
        dtpAIDSOIDate.Time := Time();
        AIDSOIDate := FloatToStr(WindowsDateToFMDate(dtpAIDSOIDate.Date));
        if dtpAIDSOIDate.Date > Now then
          hse := hse + RSC00106 + #13;   //--- Don't allow future dates
      end
      else
        AIDSOIDate := '';
      if cbgAIDSOI.Code = '' then
        hse := hse + RSC00102 + #13;

      //--- Patient History Tab

      SexWithMale := cbgSexWithMale.Code;
      SexWithFemale := cbgSexWithFemale.Code;
      NonprescrIVDrug := cbgNonprescrDrug.Code;

      ClottingFactor := cbgClottingFactor.Code;
      if ClottingFactor = '1' then
      begin
        if cbgClottingfactorType.Code <> '' then
        begin
          ClottingFactorType := cbgClottingfactorType.Code;
          if ClottingFactorType = '8' then
            if edtIVOtherFactorType.Text <> '' then
              ClottingFactorOther := edtIVOtherFactorType.Text
            else
              hse := hse + RSC00104 + #13
          else
            ClottingFactorOther := '';
        end
        else
          hse := hse + RSC00105 + #13;
      end
      else begin
        ClottingFactorType  := '';
        ClottingFactorOther := '';
      end;

      HSRwBisexualMale := cbgHSRwBisexualMale.Code;
      HSRwIVDrugUser := cbgHSRwIVDrugUser.Code;
      HSRwHemofilia := cbgHSRwHemophilia.Code;
      HSRwTransfusion := cbgHSRwTransfusion.Code;
      HSRwTransplant := cbgHSRwTransplant.Code;
      HSRwHIV := cbgHSRwHIV.Code;

      BloodComponent := cbgBloodComponent.Code;
      if BloodComponent = '1' then
      begin
        //--- Check for invalid dates and future dates
        if edtIVFirstYear.Text <> '' then
        begin
          iDateError := checkDate(edtIVFirstYear.Text);
          if iDateError = 0 then
            BloodComponentFirst := edtIVFirstYear.Text
          else if iDateError < 0 then
            hse := hse + Format(RSC00115, ['First']) + #13
          else if iDateError > 0 then
            hse := hse + Format(RSC00116, ['First']) + #13;
        end
        else
          hse := hse + RSC00113 + #13;
        if edtIVLastYear.Text <> '' then
        begin
          iDateError := checkDate(edtIVLastYear.Text);
          if iDateError = 0 then
            BloodComponentLast := edtIVLastYear.Text
          else if iDateError < 0 then
            hse := hse + Format(RSC00115, ['Last']) + #13
          else if iDateError > 0 then
            hse := hse + Format(RSC00116, ['Last']) + #13;
        end
        else
          hse := hse + RSC00114 + #13;
      end
      else begin
        BloodComponentFirst := '';
        BloodComponentLast  := '';
      end;

      Transplant := cbgTransplant.Code;

      HCWorker := cbgHCWorker.Code;
      if HCWorker = '1' then
      begin
        if edtHCOccupation.Text <> '' then
          HCWorkerOccupation := edtHCOccupation.Text
        else
          hse := hse + RSC00117 + #13
      end
      else
        HCWorkerOccupation := '';

    end;

  if (hse <> '') and (PatientData.SaveType = 'C') then
//  if hse <> '' then
    begin
      hse := RSC00100 + #13#13 + hse;
      MessageDlg508('', hse, mtWarning, [mbOK], 0);
      Result := RCE_INVALID_INPUT;
    end;
end;

end.
